﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class ProviderAgreementsMap
    {
        public static async Task<IQueryable<ProviderAgreement>> MapProviderAgreements(List<ppms_provideragreement> ppmsProviderAgreements, string mapRelatedType, PpmsContext context)
        {
            var providerAgreements = new List<ProviderAgreement> { };
            foreach (var ppmsProviderAgreement in ppmsProviderAgreements)
            {
                var providerAgreement = new ProviderAgreement
                {
                   AgreementId = ppmsProviderAgreement.ppms_agreementid
                };

                if (ppmsProviderAgreement.ppms_account_ProviderAgreementId != null)
                    providerAgreement.AgreementProviderName = ppmsProviderAgreement.ppms_account_ProviderAgreementId.Name;

                if (ppmsProviderAgreement.ppms_ProviderType != null)
                    switch (ppmsProviderAgreement.ppms_ProviderType.Value)
                    {
                        case (int)ppms_ProviderType.Individual:
                            providerAgreement.ProviderType = ProviderType.Individual;
                            break;
                        case (int)ppms_ProviderType.GroupPracticeAgency:
                            providerAgreement.ProviderType = ProviderType.GroupPracticeOrAgency;
                            break;
                        default:
                            break;
                    }

                if (ppmsProviderAgreement.ppms_CategoryofCare != null)
                    providerAgreement.CategoryOfCareName = ppmsProviderAgreement.ppms_CategoryofCare.Name;
                if (ppmsProviderAgreement.ppms_AssignedFacility != null)
                    providerAgreement.ProviderFacilityName = ppmsProviderAgreement.ppms_AssignedFacility.Name;

                if(ppmsProviderAgreement.ppms_Status != null)
                    switch (ppmsProviderAgreement.ppms_Status.Value)
                    {
                        case (int)new_ActiveInactiveList.Active:
                            providerAgreement.AgreementStatus = AgreementStatus.Active;
                            break;
                        case (int)new_ActiveInactiveList.Inactive:
                            providerAgreement.AgreementStatus = AgreementStatus.Inactive;
                            break;
                        default:
                            break;
                    }

                if (ppmsProviderAgreement.ppms_effectivedate != null)
                    providerAgreement.EffectiveDate = ppmsProviderAgreement.ppms_effectivedate.ToString();
                if (ppmsProviderAgreement.ppms_expirationdate != null)
                    providerAgreement.ExpirationDate = ppmsProviderAgreement.ppms_expirationdate.ToString();

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=ProviderServices"))
                    mapRelatedType = "ProviderServices";
                if (mapRelatedType.Contains("?$expand=AgreementProviders"))
                    mapRelatedType = "AgreementProviders";
                if (mapRelatedType.Contains("?$expand=ProviderFacility"))
                    mapRelatedType = "ProviderFacility";
                if (mapRelatedType.Contains("?$expand=CategoryOfCare"))
                    mapRelatedType = "CategoryOfCare";
                if (mapRelatedType.Contains("?$expand=AgreementProvider"))
                    mapRelatedType = "AgreementProvider";

                //Map Related Types
                switch (mapRelatedType)
                {                   
                    case "ProviderServices":
                        //Lookup and Map the Provider Services
                        var ppmsProviderServices =
                            context.ppms_providerserviceSet.Where(i => i.ppms_ProviderAgreement.Id == ppmsProviderAgreement.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        providerAgreement.ProviderServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        break;
                    case "AgreementProviders":
                        //Lookup and Map the Provider Npis
                        var ppmsAgreementProviders =
                            context.ppms_agreementproviderSet.Where(i => i.ppms_ProviderAgreement.Id == ppmsProviderAgreement.Id);
                        var ppmsAgreementProvidersList = ppmsAgreementProviders.ToList();
                        providerAgreement.AgreementProviders =
                            await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, "None", context);
                        break;

                    case "ProviderFacility":
                        //Lookup and Map the Provider Privileges
                        var ppmsProviderFacility =
                            context.va_facilitySet.FirstOrDefault(i => i.Id == ppmsProviderAgreement.ppms_AssignedFacility.Id);
                        var ppmsProviderFacilityList = new List<va_facility> { ppmsProviderFacility };
                        providerAgreement.ProviderFacility =
                            await FacilityMap.MapFacilities(ppmsProviderFacilityList, "None", context);
                        break;
                    case "CategoryOfCare":
                        //Lookup and Map the Provider Privileges
                        var ppmsCategoryOfCare =
                            context.ppms_providertaxonomySet.FirstOrDefault(i => i.Id == ppmsProviderAgreement.ppms_CategoryofCare.Id);
                        var ppmsCategoryOfCareList = new List<ppms_providertaxonomy> { ppmsCategoryOfCare };
                        providerAgreement.CategoryOfCare =
                            await ProviderSpecialtyMap.MapProviderSpecialties(ppmsCategoryOfCareList, "None", context);
                        break;
                    case "AgreementProvider":
                        //Lookup and Map the Provider Privileges
                        var ppmsAgreementProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderAgreement.ppms_account_ProviderAgreementId.Id);
                        var ppmsAgreementProviderList = new List<Account> { ppmsAgreementProvider };
                        providerAgreement.AgreementProvider =
                            await ProviderMap.MapProviders(ppmsAgreementProviderList, "None", context);
                        break;


                    default:
                        break;
                }

                providerAgreements.Add(providerAgreement);
            }
            return providerAgreements.AsQueryable();
        }      
    }
}